﻿/*		VERSION:		1.2
1.2		added tell()

USAGE:
	#include "functions/eventSystem3.as"
	if(!addListener)		AsBroadcaster.initialize(this);
	react = make_react( unloadEmitter );		// param is optional
	
	react.to("unload").from(_this).then = react.unload;
	react.to("unload").then = react.unload;
	// OR...
	function onUnload(){
		react.unload();					// this will NOT fire an "unload" event in the parent
	}
	// OR...
	function onUnload(){
		sendEvent("unload");		// this will trigger react.unload()
	}
	
	react.to("click").from(mc).then = function(evt){}
	
	var detectClick = react.to("click").from(_this);
	detectClick.then = function(evt){}
	detectClick.disable();
*/
#include "sendEvent.as"
function make_react( defaultUnloadEmitter )
{
	var react = {};		// interface
	var eventEmitters = [];
	
	
	//////////////////////////////////////////
	react.to = function( eventName ){
		var event = {};
		var tellEventTarget = null;
		
		
		// when from() is NOT used
		if( defaultUnloadEmitter ){
			var emitter = defaultUnloadEmitter;
			var _interface = event;
			
			// catch actual event => eventTarget obj
			var eventTarget = {};		// the actual events fire at this
			if(emitter.addEventListener){
				emitter.addEventListener( eventName, eventTarget );
			}else if(emitter.addListener){
				emitter.addListener( eventTarget );
			}else{
				// cannot create event,  so return nothing
				var nam = (emitter._name === undefined) ? "[object]" : '"'+emitter._name+'"';
				trace('ERROR:  '+nam+' cannot send events. ('+eventName+')');
				return null;
			}
			
			// event occurs => then()
			eventTarget[eventName] = function(){
				_interface.then.apply( null, arguments.slice() );		// when this even occurs,  run then()  and pass-thru all provided parameters to it
				// tell()
				var params = [eventName].concat( arguments.slice() );
				sendEventToTarget.apply( null, params );		// when this even occurs,  pass the event to the tellEventTarget
			}// upon event()
			
			// remember this event
			var eventDetails = {
				emitter: emitter,
				eventName: eventName,
				eventTarget: eventTarget
			}
			eventEmitters.push(eventDetails);
			
			// manually destroy event
			_interface.disable = function(){
				disableEvent( emitter, eventName, eventTarget );
				forgetEvent( emitter, eventName, eventTarget );
			}// disable()
		}// if:  default emitter was specified
		
		
		// when tell() is specified
		event.tell = function( newTarget ){
			tellEventTarget = newTarget;
			return event;		// make this a chain-able monad
		}// tell()
		
		
		function sendEventToTarget(eventName, evt){
			if(!tellEventTarget)		return;
			
			sendEvent(eventName,evt,tellEventTarget);
		}// sendEventToTarget()
		
		
		// when from() is specified
		event.from = function( emitter ){
			event.disable();		// replace react.to().then events
			
			var _interface = {};
			
			// catch actual event => eventTarget obj
			var eventTarget = {};		// the actual events fire at this
			if(emitter.addEventListener){
				emitter.addEventListener( eventName, eventTarget );
			}else if(emitter.addListener){
				emitter.addListener( eventTarget );
			}else{
				// cannot create event,  so return nothing
				var nam = (emitter._name === undefined) ? "[object]" : '"'+emitter._name+'"';
				trace('ERROR:  '+nam+' cannot send events. ('+eventName+')');
				return null;
			}
			
			// event occurs => then()
			eventTarget[eventName] = function(){
				_interface.then.apply( null, arguments.slice() );		// when this even occurs,  run then()  and pass-thru all provided parameters to it
				// tell()
				var params = [eventName].concat( arguments.slice() );
				sendEventToTarget.apply( null, params );		// when this even occurs,  pass the event to the tellEventTarget
			}// upon event()
			
			// remember this event
			var eventDetails = {
				emitter: emitter,
				eventName: eventName,
				eventTarget: eventTarget
			}
			eventEmitters.push(eventDetails);
			
			// manually destroy event
			_interface.disable = function(){
				disableEvent( emitter, eventName, eventTarget );
				forgetEvent( emitter, eventName, eventTarget );
			}// disable()
			_interface.tell = event.tell;
			
			// output:  {}.then
			return _interface;
		}// from()
		
		
		// output:  {}.then  {}.from()
		return event;
	}// to()
	
	
	function unload(){
		for(var nam in eventEmitters){
			var details = eventEmitters[nam];
			var emitter = details.emitter;
			var eventName = details.eventName;
			var eventTarget = details.eventTarget;
			disableEvent( emitter, eventName, eventTarget );
		}// for:  each known event
		eventEmitters = [];
	}// unload()
	react.unload = once( unload );
	
	
	//////////////////////////////////////////
	if(defaultUnloadEmitter){
		react.to("unload").then = react.unload;
	}// if:  defaultUnloadEmitter is specified
	
	
	return react;
	
	
	//////////////////////////////////////////
	function disableEvent( emitter, eventName, eventTarget )
	{
		if(emitter.removeEventListener){
			emitter.removeEventListener( eventName, eventTarget );
		}else{
			emitter.removeListener( eventTarget );
		}
	}// disableEvent()
	
	
	function forgetEvent( emitter, eventName, eventTarget )
	{
		for(var e in eventEmitters){
			var thisEvent = eventEmitters[e];
			if(thisEvent.emitter			!== emitter)				continue;		// no match,  so don't remove
			if(thisEvent.eventName		!== eventName)			continue;		// no match,  so don't remove
			if(thisEvent.eventTarget	!== eventTarget)		continue;		// no match,  so don't remove
			// remove
			eventEmitters.splice( e, 1 );
		}// for:  each known event
		delete thisEvent;
	}// forgetEvent()
	
	
	function once( func ){
		var done = false;
		return function () {
			return done ? void 0 : ((done = true), func.apply(this, arguments));
		}
	}// once()
	
}// make_react()